//
//  AppDelegate.m
//  SimpleSearchApp
//
//  Created by ub on 16.07.09.
//  Copyright 2009 Udo Borkowski. All rights reserved.
//

#import "AppDelegate.h"

#import "Carbon/Carbon.h"

#import "FSLabelToColorNameTransformer.h"
#import "MetadataItemTransformer.h"

@implementation AppDelegate

+ (void)initialize {
    // Only initialize once
    if (self != [AppDelegate class]) {
		return;
	}
	
	NSValueTransformer* trans = [[FSLabelToColorNameTransformer alloc] init];
	[NSValueTransformer setValueTransformer:trans forName:@"FSLabelToColorNameTransformer"];
	[trans release];

	trans = [[MetadataItemTransformer alloc] init];
	[NSValueTransformer setValueTransformer:trans forName:@"MetadataItemTransformer"];
	[trans release];	
}
	
	
- (void) awakeFromNib
{
	// Open windows on startup
	//[self showSpotlightResultGroupingDemoWindowController: self];
}

// show the Spotlight Search Window
- (IBAction)showSpotlightSearchWindowAction:(id)sender;
{ 
    OSStatus resultCode = 
			HISearchWindowShow((CFStringRef)@"Leopard", kNilOptions);
    if (resultCode != noErr) { 
		//... ignore
    } 
} 

- (MetadataWindowController*)MetadataWindowController;
{
	if (!metadataWindowController) {
		metadataWindowController = [[MetadataWindowController alloc]init];
	}
	return metadataWindowController;
}

- (IBAction)showTableStyleSearchWindowAction:(id)sender;
{ 
	[self.MetadataWindowController showWindow:self];
} 

- (SpotlightQueryBasicsDemoWindowController*) spotlightQueryBasicsDemoWindowController
{
	if (!spotlightQueryBasicsDemoWindowController) {
		spotlightQueryBasicsDemoWindowController = [[SpotlightQueryBasicsDemoWindowController alloc]init];
	}
	return spotlightQueryBasicsDemoWindowController;
}

- (IBAction)showSpotlightQueryBasicsDemoWindowController:(id)sender
{ 
	[self.spotlightQueryBasicsDemoWindowController showWindow:self];
} 

- (SpotlightQueryScopeDemoWindowController*) spotlightQueryScopeDemoWindowController
{
	if (!spotlightQueryScopeDemoWindowController) {
		spotlightQueryScopeDemoWindowController = [[SpotlightQueryScopeDemoWindowController alloc]init];
	}
	return spotlightQueryScopeDemoWindowController;
}

- (IBAction)showSpotlightQueryScopeDemoWindowController:(id)sender
{ 
	[self.spotlightQueryScopeDemoWindowController showWindow:self];
} 

- (SpotlightResultSortingDemoWindowController*) spotlightResultSortingDemoWindowController
{
	if (!spotlightResultSortingDemoWindowController) {
		spotlightResultSortingDemoWindowController = [[SpotlightResultSortingDemoWindowController alloc]init];
	}
	return spotlightResultSortingDemoWindowController;
}

- (IBAction)showSpotlightResultSortingDemoWindowController:(id)sender
{ 
	[self.spotlightResultSortingDemoWindowController showWindow:self];
} 


- (SpotlightResultGroupingDemoWindowController*) spotlightResultGroupingDemoWindowController
{
	if (!spotlightResultGroupingDemoWindowController) {
		spotlightResultGroupingDemoWindowController = [[SpotlightResultGroupingDemoWindowController alloc]init];
	}
	return spotlightResultGroupingDemoWindowController;
}

- (IBAction)showSpotlightResultGroupingDemoWindowController:(id)sender
{ 
	[self.spotlightResultGroupingDemoWindowController showWindow:self];
} 


- (SpotlightValueListsDemoWindowController*) spotlightValueListsDemoWindowController
{
	if (!spotlightValueListsDemoWindowController) {
		spotlightValueListsDemoWindowController = [[SpotlightValueListsDemoWindowController alloc]init];
	}
	return spotlightValueListsDemoWindowController;
}

- (IBAction)showSpotlightValueListsDemoWindowController:(id)sender
{ 
	[self.spotlightValueListsDemoWindowController showWindow:self];
} 


@end
